
; COMCTL32.DLL structures and constants

struct PROPSHEETPAGE
  dwSize      dd ?
  dwFlags     dd ?
  hInstance   dd ?
  pszTemplate dd ?
  pszIcon     dd ?
  pszTitle    dd ?
  pfnDlgProc  dd ?
  lParam      dd ?
  pfnCallback dd ?
  pcRefParent dd ?
ends

struct PROPSHEETHEADER
  dwSize     dd ?
  dwFlags    dd ?
  hwndParent dd ?
  hInstance  dd ?
  pszIcon    dd ?
  pszCaption dd ?
  nPages     dd ?
  pStartPage dd ?
ends

struct IMAGEINFO
  hbmImage dd ?
  hbmMask  dd ?
  Unused1  dd ?
  Unused2  dd ?
  rcImage  dd ?
ends

struct HDITEM
  mask	     dd ?
  cxy	     dd ?
  pszText    dd ?
  hbm	     dd ?
  cchTextMax dd ?
  fmt	     dd ?
  lParam     dd ?
ends

struct HDLAYOUT
  prc	dd ?
  pwpos dd ?
ends

struct HDHITTESTINFO
  pt	POINT
  flags dd ?
  iItem dd ?
ends

struct HDNOTIFY
  hdr	  NMHDR
  iItem   dd ?
  iButton dd ?
  pitem   dd ?
ends

struct TBBUTTON
  iBitmap   dd ?
  idCommand dd ?
  fsState   db ?
  fsStyle   db ?
	    dw ?
  dwData    dd ?
  iString   dd ?
ends

struct COLORMAP
  from dd ?
  to   dd ?
ends

struct TBADDBITMAP
  hInst dd ?
  nID	dd ?
ends

struct TBSAVEPARAMS
  hkr	       dd ?
  pszSubKey    dd ?
  pszValueName dd ?
ends

struct TBREPLACEBITMAP
  hInstOld dd ?
  nIDOld   dd ?
  hInstNew dd ?
  nIDNew   dd ?
  nButtons dd ?
ends

struct NMTOOLBAR
  hdr	   NMHDR
  iItem    dd ?
  tbButton TBBUTTON
  cchText  dd ?
  pszText  dd ?
ends

struct REBARINFO
  cbSize dd ?
  fMask  dd ?
  himl	 dd ?
ends

struct REBARBANDINFO
  cbSize      dd ?
  fMask       dd ?
  fStyle      dd ?
  clrFore     dd ?
  clrBack     dd ?
  lpText      dd ?
  cch	      dd ?
  iImage      dd ?
  hwndChild   dd ?
  cxMinChild  dd ?
  cyMinChild  dd ?
  cx	      dd ?
  hbmBack     dd ?
  wID	      dd ?
ends

struct TOOLINFO
  cbSize   dd ?
  uFlags   dd ?
  hwnd	   dd ?
  uId	   dd ?
  Rect	   RECT
  hInst    dd ?
  lpszText dd ?
ends

struct TTHITTESTINFO
  hwnd dd ?
  pt   POINT
  ti   TOOLINFO
ends

struct TOOLTOPTEXT
  hdr	   NMHDR
  lpszText dd ?
  szText   db 80 dup (?)
  hinst    dd ?
  uFlags   dd ?
ends

struct UDACCEL
  nSec dd ?
  nInc dd ?
ends

struct NMUPDOWN
  hdr	 NMHDR
  iPos	 dd ?
  iDelta dd ?
ends

struct LVITEM
  mask	     dd ?
  iItem      dd ?
  iSubItem   dd ?
  state      dd ?
  stateMask  dd ?
  pszText    dd ?
  cchTextMax dd ?
  iImage     dd ?
  lParam     dd ?
  iIndent    dd ?
ends

struct LVFINDINFO
  flags       dd ?
  psz	      dd ?
  lParam      dd ?
  pt	      POINT
  vkDirection dd ?
ends

struct LVHITTESTINFO
  pt	POINT
  flags dd ?
  iItem dd ?
ends

struct LVCOLUMN
  mask	     dd ?
  fmt	     dd ?
  cx	     dd ?
  pszText    dd ?
  cchTextMax dd ?
  iSubItem   dd ?
ends

struct NMLISTVIEW
  hdr	    NMHDR
  iItem     dd ?
  iSubItem  dd ?
  uNewState dd ?
  uOldState dd ?
  uChanged  dd ?
  ptAction  POINT
  lParam    dd ?
ends

struct NMCACHEHINT
  hdr	NMHDR
  iFrom dd ?
  iTo	dd ?
ends

struct NMFINDITEM
  hdr	 NMHDR
  iStart dd ?
  lvfi	 LVFINDINFO
ends

struct LVDISPINFO
  hdr  NMHDR
  item LVITEM
ends

struct LVKEYDOWN
  hdr	NMHDR
  wVKey dw ?
  flags dd ?
ends

struct TVITEM
  mask		 dd ?
  hItem 	 dd ?
  state 	 dd ?
  stateMask	 dd ?
  pszText	 dd ?
  cchTextMax	 dd ?
  iImage	 dd ?
  iSelectedImage dd ?
  cChildren	 dd ?
  lParam	 dd ?
ends

struct TVINSERTSTRUCT
  hParent      dd ?
  hInsertAfter dd ?
  item	       TVITEM
ends

struct TVHITTESTINFO
  pt	POINT
  flags dd ?
  hItem dd ?
ends

struct TVSORTCB
  hParent     dd ?
  lpfnCompare dd ?
  lParam      dd ?
ends

struct NMTREEVIEW
  hdr	  NMHDR
  action  dd ?
  itemOld TVITEM
  itemNew TVITEM
  ptDrag  POINT
ends

struct TVDISPINFO
  hdr  NMHDR
  item TVITEM
ends

struct TVKEYDOWN
  hdr	NMHDR
  wVKey dw ?
  flags dd ?
ends

struct TCITEMHEADER
  mask	      dd ?
  lpReserved1 dd ?
  lpReserved2 dd ?
  pszText     dd ?
  cchTextMax  dd ?
  iImage      dd ?
ends

struct TCITEM
  mask	      dd ?
  lpReserved1 dd ?
  lpReserved2 dd ?
  pszText     dd ?
  cchTextMax  dd ?
  iImage      dd ?
  lParam      dd ?
ends

struct TCHITTESTINFO
  pt	POINT
  flags dd ?
ends

struct TCKEYDOWN
  hdr	NMHDR
  wVKey dw ?
  flags dd ?
ends

struct MCHITTESTINFO
  cbSize dd ?
  pt	 POINT
  uHit	 dd ?
  st	 SYSTEMTIME
ends

struct NMSELCHANGE
  nmhdr      NMHDR
  stSelStart SYSTEMTIME
  stSelEnd   SYSTEMTIME
ends

struct NMDAYSTATE
  nmhdr       NMHDR
  stStart     SYSTEMTIME
  cDayState   dd ?
  prgDayState dd ?
ends

struct NMDATETIMECHANGE
  nmhdr   NMHDR
  dwFlags dd ?
  st	  SYSTEMTIME
ends

struct NMDATETIMESTRING
  nmhdr 	NMHDR
  pszUserString dd ?
  st		SYSTEMTIME
  dwFlags	dd ?
ends

struct NMDATETIMEWMKEYDOWN
  nmhdr     NMHDR
  nVirtKey  dd ?
  pszFormat dd ?
  st	    SYSTEMTIME
ends

struct NMDATETIMEFORMAT
  nmhdr      NMHDR
  pszFormat  dd ?
  st	     SYSTEMTIME
  pszDisplay dd ?
  szDisplay  db 64 dup (?)
ends

struct NMDATETIMEFORMATQUERY
  nmhdr     NMHDR
  pszFormat dd ?
  szMax     SIZE
ends

struct NMCUSTOMDRAW
  hdr	      NMHDR
  dwDrawStage dd ?
  hdc	      dd ?
  rc	      RECT
  dwItemSpec  dd ?
  uItemState  dd ?
  lItemlParam dd ?
ends

struct NMLVCUSTOMDRAW
  nmcd	      NMCUSTOMDRAW
  clrText     dd ?
  clrTextBk   dd ?
  iSubItem    dd ?
  dwItemType  dd ?
  clrFace     dd ?
  iIconEffect dd ?
  iIconPhase  dd ?
  iPartId     dd ?
  iStateId    dd ?
  rcText      RECT
  uAlign      dd ?
ends

struct INITCOMMONCONTROLSEX
  dwSize dd ?
  dwICC  dd ?
ends

; Common control window classes

HOTKEY_CLASS	   equ 'msctls_hotkey32'
PROGRESS_CLASS	   equ 'msctls_progress32'
STATUS_CLASS	   equ 'msctls_statusbar32'
TRACKBAR_CLASS	   equ 'msctls_trackbar32'
UPDOWN_CLASS	   equ 'msctls_updown32'
TOOLTIPS_CLASS	   equ 'tooltips_class32'
ANIMATE_CLASS	   equ 'SysAnimate32'
HEADER_CLASS	   equ 'SysHeader32'
LISTVIEW_CLASS	   equ 'SysListView32'
TREEVIEW_CLASS	   equ 'SysTreeView32'
TABCONTROL_CLASS   equ 'SysTabControl32'
MONTHCAL_CLASS	   equ 'SysMonthCal32'
DATETIMEPICK_CLASS equ 'SysDateTimePick32'
TOOLBAR_CLASS	   equ 'ToolbarWindow32'
REBAR_CLASS	   equ 'ReBarWindow32'

; Ranges for control message IDs

LVM_FIRST = 1000h
TV_FIRST  = 1100h
HDM_FIRST = 1200h
TCM_FIRST = 1300h
MCM_FIRST = 1000h
DTM_FIRST = 1000h
CCM_FIRST = 2000h

; Ranges for control notification IDs

NM_FIRST   = 0
LVN_FIRST  = -100
PSN_FIRST  = -200
HDN_FIRST  = -300
TVN_FIRST  = -400
TTN_FIRST  = -520
TCN_FIRST  = -550
CDN_FIRST  = -601
TBN_FIRST  = -700
UDN_FIRST  = -721
MCN_FIRST  = -750
DTN_FIRST  = -760
CBEN_FIRST = -800
RBN_FIRST  = -831

; Generic notifications

NM_OUTOFMEMORY = NM_FIRST - 1
NM_CLICK       = NM_FIRST - 2
NM_DBLCLK      = NM_FIRST - 3
NM_RETURN      = NM_FIRST - 4
NM_RCLICK      = NM_FIRST - 5
NM_RDBLCLK     = NM_FIRST - 6
NM_SETFOCUS    = NM_FIRST - 7
NM_KILLFOCUS   = NM_FIRST - 8
NM_CUSTOMDRAW  = NM_FIRST - 12

; Common control styles

CCS_TOP 	  = 01h
CCS_NOMOVEY	  = 02h
CCS_BOTTOM	  = 03h
CCS_NORESIZE	  = 04h
CCS_NOPARENTALIGN = 08h
CCS_ADJUSTABLE	  = 20h
CCS_NODIVIDER	  = 40h
CCS_VERT	  = 80h
CCS_LEFT	  = CCS_VERT or CCS_TOP
CCS_RIGHT	  = CCS_VERT or CCS_BOTTOM
CCS_NOMOVEX	  = CCS_VERT or CCS_NOMOVEY

; Owner-drawn control types

ODT_HEADER   = 100
ODT_TAB      = 101
ODT_LISTVIEW = 102

; InitCommonControlsEx classes

ICC_ANIMATE_CLASS      = 0080h
ICC_BAR_CLASSES        = 0004h
ICC_COOL_CLASSES       = 0400h
ICC_DATE_CLASSES       = 0100h
ICC_HOTKEY_CLASS       = 0040h
ICC_INTERNET_CLASSES   = 0800h
ICC_LISTVIEW_CLASSES   = 0001h
ICC_PAGESCROLLER_CLASS = 1000h
ICC_PROGRESS_CLASS     = 0020h
ICC_TAB_CLASSES        = 0008h
ICC_TREEVIEW_CLASSES   = 0002h
ICC_UPDOWN_CLASS       = 0010h
ICC_USEREX_CLASSES     = 0200h
ICC_WIN95_CLASSES      = 00FFh

; Shared messages

CCM_SETCOLORSCHEME   = CCM_FIRST + 2
CCM_GETCOLORSCHEME   = CCM_FIRST + 3
CCM_GETDROPTARGET    = CCM_FIRST + 4
CCM_SETUNICODEFORMAT = CCM_FIRST + 5
CCM_GETUNICODEFORMAT = CCM_FIRST + 6

; Property sheet page flags

PSP_DEFAULT	 = 0000h
PSP_DLGINDIRECT  = 0001h
PSP_USEHICON	 = 0002h
PSP_USEICONID	 = 0004h
PSP_USETITLE	 = 0008h
PSP_HASHELP	 = 0020h
PSP_USEREFPARENT = 0040h
PSP_USECALLBACK  = 0080h

; Property sheet page actions

PSPCB_RELEASE = 1
PSPCB_CREATE  = 2

; Property sheet header flags

PSH_DEFAULT	  = 0000h
PSH_PROPTITLE	  = 0001h
PSH_USEHICON	  = 0002h
PSH_USEICONID	  = 0004h
PSH_PROPSHEETPAGE = 0008h
PSH_MULTILINETABS = 0010h
PSH_WIZARD	  = 0020h
PSH_USEPSTARTPAGE = 0040h
PSH_NOAPPLYNOW	  = 0080h
PSH_USECALLBACK   = 0100h
PSH_HASHELP	  = 0200h
PSH_MODELESS	  = 0400h

; Property sheet actions

PSCB_INITIALIZED  = 1

; Property sheet notifications

PSN_SETACTIVE	= PSN_FIRST - 0
PSN_KILLACTIVE	= PSN_FIRST - 1
PSN_APPLY	= PSN_FIRST - 2
PSN_RESET	= PSN_FIRST - 3
PSN_HELP	= PSN_FIRST - 5
PSN_WIZBACK	= PSN_FIRST - 6
PSN_WIZNEXT	= PSN_FIRST - 7
PSN_WIZFINISH	= PSN_FIRST - 8
PSN_QUERYCANCEL = PSN_FIRST - 9

; Property sheet return values

PSNRET_NOERROR		    = 0
PSNRET_INVALID		    = 1
PSNRET_INVALID_NOCHANGEPAGE = 2

; Property sheet messages

PSM_SETCURSEL	    = WM_USER + 101
PSM_REMOVEPAGE	    = WM_USER + 102
PSM_ADDPAGE	    = WM_USER + 103
PSM_CHANGED	    = WM_USER + 104
PSM_RESTARTWINDOWS  = WM_USER + 105
PSM_REBOOTSYSTEM    = WM_USER + 106
PSM_CANCELTOCLOSE   = WM_USER + 107
PSM_QUERYSIBLINGS   = WM_USER + 108
PSM_UNCHANGED	    = WM_USER + 109
PSM_APPLY	    = WM_USER + 110
PSM_SETTITLE	    = WM_USER + 111
PSM_SETTITLEW	    = WM_USER + 120
PSM_SETWIZBUTTONS   = WM_USER + 112
PSM_PRESSBUTTON     = WM_USER + 113
PSM_SETCURSELID     = WM_USER + 114
PSM_SETFINISHTEXT   = WM_USER + 115
PSM_SETFINISHTEXTW  = WM_USER + 121
PSM_GETTABCONTROL   = WM_USER + 116
PSM_ISDIALOGMESSAGE = WM_USER + 117

; Property sheet buttons

PSBTN_BACK	      = 0
PSBTN_NEXT	      = 1
PSBTN_FINISH	      = 2
PSBTN_OK	      = 3
PSBTN_APPLYNOW	      = 4
PSBTN_CANCEL	      = 5
PSBTN_HELP	      = 6
PSWIZB_BACK	      = 1
PSWIZB_NEXT	      = 2
PSWIZB_FINISH	      = 4
PSWIZB_DISABLEDFINISH = 8
ID_PSRESTARTWINDOWS   = 2
ID_PSREBOOTSYSTEM     = ID_PSRESTARTWINDOWS or 1

; Property sheet sizes

PROP_SM_CXDLG  = 212
PROP_SM_CYDLG  = 188
PROP_MED_CXDLG = 227
PROP_MED_CYDLG = 215
PROP_LG_CXDLG  = 252
PROP_LG_CYDLG  = 218
WIZ_CXDLG      = 276
WIZ_CYDLG      = 140
WIZ_CXBMP      = 80
WIZ_BODYX      = 92
WIZ_BODYCX     = 184

; Image list types

ILC_MASK     = 001h
ILC_COLOR    = 0FEh
ILC_COLORDDB = 0FEh
ILC_COLOR4   = 004h
ILC_COLOR8   = 008h
ILC_COLOR16  = 010h
ILC_COLOR24  = 018h
ILC_COLOR32  = 020h
ILC_PALETTE  = 800h

; Image list color values

CLR_NONE    = 0FFFFFFFFh
CLR_DEFAULT = 0FF000000h
CLR_HILIGHT = CLR_DEFAULT

; Image list drawing styles

ILD_NORMAL	= 0000h
ILD_TRANSPARENT = 0001h
ILD_MASK	= 0010h
ILD_IMAGE	= 0020h
ILD_BLEND25	= 0002h
ILD_BLEND50	= 0004h
ILD_OVERLAYMASK = 0F00h
ILD_SELECTED	= ILD_BLEND50
ILD_FOCUS	= ILD_BLEND25
ILD_BLEND	= ILD_BLEND50

; Header control styles

HDS_HORZ     = 00h
HDS_BUTTONS  = 02h
HDS_HOTTRACK = 04h
HDS_HIDDEN   = 08h
HDS_DRAGDROP = 40h
HDS_FULLDRAG = 80h

; Header control structure flags

HDI_WIDTH  = 01h
HDI_HEIGHT = HDI_WIDTH
HDI_TEXT   = 02h
HDI_FORMAT = 04h
HDI_LPARAM = 08h
HDI_BITMAP = 10h

; Header control flags

HDF_LEFT	= 0000h
HDF_RIGHT	= 0001h
HDF_CENTER	= 0002h
HDF_JUSTIFYMASK = 0003h
HDF_RTLREADING	= 0004h
HDF_BITMAP	= 2000h
HDF_STRING	= 4000h
HDF_OWNERDRAW	= 8000h

; Header control messages

HDM_GETITEMCOUNT = HDM_FIRST + 0
HDM_INSERTITEMA  = HDM_FIRST + 1
HDM_DELETEITEM	 = HDM_FIRST + 2
HDM_GETITEMA	 = HDM_FIRST + 3
HDM_SETITEMA	 = HDM_FIRST + 4
HDM_LAYOUT	 = HDM_FIRST + 5
HDM_HITTEST	 = HDM_FIRST + 6
HDM_INSERTITEMW  = HDM_FIRST + 10
HDM_GETITEMW	 = HDM_FIRST + 11
HDM_SETITEMW	 = HDM_FIRST + 12
HDM_INSERTITEM	 = HDM_INSERTITEMA
HDM_GETITEM	 = HDM_GETITEMA
HDM_SETITEM	 = HDM_SETITEMA

; Hit test result flags

HHT_NOWHERE   = 001h
HHT_ONHEADER  = 002h
HHT_ONDIVIDER = 004h
HHT_ONDIVOPEN = 008h
HHT_ABOVE     = 100h
HHT_BELOW     = 200h
HHT_TORIGHT   = 400h
HHT_TOLEFT    = 800h

; Header control notifications

HDN_ITEMCHANGINGA    = HDN_FIRST - 0
HDN_ITEMCHANGEDA     = HDN_FIRST - 1
HDN_ITEMCLICKA	     = HDN_FIRST - 2
HDN_ITEMDBLCLICKA    = HDN_FIRST - 3
HDN_DIVIDERDBLCLICKA = HDN_FIRST - 5
HDN_BEGINTRACKA      = HDN_FIRST - 6
HDN_ENDTRACKA	     = HDN_FIRST - 7
HDN_TRACKA	     = HDN_FIRST - 8
HDN_ITEMCHANGINGW    = HDN_FIRST - 20
HDN_ITEMCHANGEDW     = HDN_FIRST - 21
HDN_ITEMCLICKW	     = HDN_FIRST - 22
HDN_ITEMDBLCLICKW    = HDN_FIRST - 23
HDN_DIVIDERDBLCLICKW = HDN_FIRST - 25
HDN_BEGINTRACKW      = HDN_FIRST - 26
HDN_ENDTRACKW	     = HDN_FIRST - 27
HDN_TRACKW	     = HDN_FIRST - 28
HDN_ITEMCHANGING     = HDN_ITEMCHANGINGA
HDN_ITEMCHANGED      = HDN_ITEMCHANGEDA
HDN_ITEMCLICK	     = HDN_ITEMCLICKA
HDN_ITEMDBLCLICK     = HDN_ITEMDBLCLICKA
HDN_DIVIDERDBLCLICK  = HDN_DIVIDERDBLCLICKA
HDN_BEGINTRACK	     = HDN_BEGINTRACKA
HDN_ENDTRACK	     = HDN_ENDTRACKA
HDN_TRACK	     = HDN_TRACKA

; Toolbar bitmap flags

CMB_MASKED = 2

; Toolbar button states

TBSTATE_CHECKED       = 01h
TBSTATE_PRESSED       = 02h
TBSTATE_ENABLED       = 04h
TBSTATE_HIDDEN	      = 08h
TBSTATE_INDETERMINATE = 10h
TBSTATE_WRAP	      = 20h
TBSTATE_ELLIPSES      = 40h

; Toolbar button styles

TBSTYLE_BUTTON	    = 0000h
TBSTYLE_SEP	    = 0001h
TBSTYLE_CHECK	    = 0002h
TBSTYLE_GROUP	    = 0004h
TBSTYLE_CHECKGROUP  = TBSTYLE_GROUP or TBSTYLE_CHECK
TBSTYLE_DROPDOWN    = 0008h
TBSTYLE_TOOLTIPS    = 0100h
TBSTYLE_WRAPABLE    = 0200h
TBSTYLE_ALTDRAG     = 0400h
TBSTYLE_FLAT	    = 0800h
TBSTYLE_LIST	    = 1000h
TBSTYLE_CUSTOMERASE = 2000h
TBSTYLE_TRANSPARENT = 8000h

; Toolbar button extended styles

TBSTYLE_EX_DRAWDDARROWS = 0001h

; Toolbar messages

TB_ENABLEBUTTON 	 = WM_USER + 1
TB_CHECKBUTTON		 = WM_USER + 2
TB_PRESSBUTTON		 = WM_USER + 3
TB_HIDEBUTTON		 = WM_USER + 4
TB_INDETERMINATE	 = WM_USER + 5
TB_ISBUTTONENABLED	 = WM_USER + 9
TB_ISBUTTONCHECKED	 = WM_USER + 10
TB_ISBUTTONPRESSED	 = WM_USER + 11
TB_ISBUTTONHIDDEN	 = WM_USER + 12
TB_ISBUTTONINDETERMINATE = WM_USER + 13
TB_SETSTATE		 = WM_USER + 17
TB_GETSTATE		 = WM_USER + 18
TB_ADDBITMAP		 = WM_USER + 19
TB_ADDBUTTONS		 = WM_USER + 20
TB_INSERTBUTTON 	 = WM_USER + 21
TB_DELETEBUTTON 	 = WM_USER + 22
TB_GETBUTTON		 = WM_USER + 23
TB_BUTTONCOUNT		 = WM_USER + 24
TB_COMMANDTOINDEX	 = WM_USER + 25
TB_SAVERESTOREA 	 = WM_USER + 26
TB_ADDSTRINGA		 = WM_USER + 28
TB_CUSTOMIZE		 = WM_USER + 27
TB_GETITEMRECT		 = WM_USER + 29
TB_BUTTONSTRUCTSIZE	 = WM_USER + 30
TB_SETBUTTONSIZE	 = WM_USER + 31
TB_SETBITMAPSIZE	 = WM_USER + 32
TB_AUTOSIZE		 = WM_USER + 33
TB_GETTOOLTIPS		 = WM_USER + 35
TB_SETTOOLTIPS		 = WM_USER + 36
TB_SETPARENT		 = WM_USER + 37
TB_SETROWS		 = WM_USER + 39
TB_GETROWS		 = WM_USER + 40
TB_GETBITMAPFLAGS	 = WM_USER + 41
TB_SETCMDID		 = WM_USER + 42
TB_CHANGEBITMAP 	 = WM_USER + 43
TB_GETBITMAP		 = WM_USER + 44
TB_GETBUTTONTEXTA	 = WM_USER + 45
TB_REPLACEBITMAP	 = WM_USER + 46
TB_SETINDENT		 = WM_USER + 47
TB_SETIMAGELIST 	 = WM_USER + 48
TB_GETIMAGELIST 	 = WM_USER + 49
TB_LOADIMAGES		 = WM_USER + 50
TB_GETRECT		 = WM_USER + 51
TB_SETHOTIMAGELIST	 = WM_USER + 52
TB_GETHOTIMAGELIST	 = WM_USER + 53
TB_SETDISABLEDIMAGELIST  = WM_USER + 54
TB_GETDISABLEDIMAGELIST  = WM_USER + 55
TB_SETSTYLE		 = WM_USER + 56
TB_GETSTYLE		 = WM_USER + 57
TB_GETBUTTONSIZE	 = WM_USER + 58
TB_SETBUTTONWIDTH	 = WM_USER + 59
TB_SETMAXTEXTROWS	 = WM_USER + 60
TB_GETTEXTROWS		 = WM_USER + 61
TB_GETBUTTONTEXTW	 = WM_USER + 75
TB_SAVERESTOREW 	 = WM_USER + 76
TB_ADDSTRINGW		 = WM_USER + 77
TB_SETEXTENDEDSTYLE	 = WM_USER + 84
TB_GETEXTENDEDSTYLE	 = WM_USER + 85
TB_GETBUTTONTEXT	 = TB_GETBUTTONTEXTA
TB_SAVERESTORE		 = TB_SAVERESTOREA
TB_ADDSTRING		 = TB_ADDSTRINGA

; System-defined button bitmaps

HINST_COMMCTRL	     = -1
IDB_STD_SMALL_COLOR  = 0
IDB_STD_LARGE_COLOR  = 1
IDB_VIEW_SMALL_COLOR = 4
IDB_VIEW_LARGE_COLOR = 5
IDB_HIST_SMALL_COLOR = 8
IDB_HIST_LARGE_COLOR = 9

; Icon indexes for standard bitmap

STD_CUT        = 0
STD_COPY       = 1
STD_PASTE      = 2
STD_UNDO       = 3
STD_REDOW      = 4
STD_DELETE     = 5
STD_FILENEW    = 6
STD_FILEOPEN   = 7
STD_FILESAVE   = 8
STD_PRINTPRE   = 9
STD_PROPERTIES = 10
STD_HELP       = 11
STD_FIND       = 12
STD_REPLACE    = 13
STD_PRINT      = 14

; Icon indexes for standard view bitmap

VIEW_LARGEICONS    = 0
VIEW_SMALLICONS    = 1
VIEW_LIST	   = 2
VIEW_DETAILS	   = 3
VIEW_SORTNAME	   = 4
VIEW_SORTSIZE	   = 5
VIEW_SORTDATE	   = 6
VIEW_SORTTYPE	   = 7
VIEW_PARENTFOLDER  = 8
VIEW_NETCONNECT    = 9
VIEW_NETDISCONNECT = 10
VIEW_NEWFOLDER	   = 11

; Icon indexes for history bitmap

HIST_BACK	    = 0
HIST_FORWARD	    = 1
HIST_FAVORITES	    = 2
HIST_ADDTOFAVORITES = 3
HIST_VIEWTREE	    = 4

; Toolbar bitmap flags

TBBF_LARGE = 1

; Toolbar notifications

TBN_GETBUTTONINFOA = TBN_FIRST - 0
TBN_BEGINDRAG	   = TBN_FIRST - 1
TBN_ENDDRAG	   = TBN_FIRST - 2
TBN_BEGINADJUST    = TBN_FIRST - 3
TBN_ENDADJUST	   = TBN_FIRST - 4
TBN_RESET	   = TBN_FIRST - 5
TBN_QUERYINSERT    = TBN_FIRST - 6
TBN_QUERYDELETE    = TBN_FIRST - 7
TBN_TOOLBARCHANGE  = TBN_FIRST - 8
TBN_CUSTHELP	   = TBN_FIRST - 9
TBN_DROPDOWN	   = TBN_FIRST - 10
TBN_CLOSEUP	   = TBN_FIRST - 11
TBN_GETBUTTONINFOW = TBN_FIRST - 20
TBN_GETBUTTONINFO  = TBN_GETBUTTONINFOA

; ReBar styles

RBS_TOOLTIPS	    = 100h
RBS_VARHEIGHT	    = 200h
RBS_BANDBORDERS     = 400h
RBS_FIXEDORDER	    = 800h
RBS_REGISTERDROP    = 1000h
RBS_AUTOSIZE	    = 2000h
RBS_VERTICALGRIPPER = 4000h
RBS_DBLCLKTOGGLE    = 8000h

; ReBar band info structure flags

RBBIM_STYLE	 = 001h
RBBIM_COLORS	 = 002h
RBBIM_TEXT	 = 004h
RBBIM_IMAGE	 = 008h
RBBIM_CHILD	 = 010h
RBBIM_CHILDSIZE  = 020h
RBBIM_SIZE	 = 040h
RBBIM_BACKGROUND = 080h
RBBIM_ID	 = 100h
RBBIM_IDEALSIZE  = 200h
RBBIM_LPARAM	 = 400h
RBBIM_HEADERSIZE = 800h

; ReBar band styles

RBBS_BREAK	    = 001h
RBBS_FIXEDSIZE	    = 002h
RBBS_CHILDEDGE	    = 004h
RBBS_HIDDEN	    = 008h
RBBS_NOVERT	    = 010h
RBBS_FIXEDBMP	    = 020h
RBBS_VARIABLEHEIGHT = 040h
RBBS_GRIPPERALWAYS  = 080h
RBBS_NOGRIPPER	    = 100h

; ReBar messages

RB_INSERTBANDA	    = WM_USER + 1
RB_DELETEBAND	    = WM_USER + 2
RB_GETBARINFO	    = WM_USER + 3
RB_SETBARINFO	    = WM_USER + 4
RB_GETBANDINFO	    = WM_USER + 5
RB_SETBANDINFOA     = WM_USER + 6
RB_SETPARENT	    = WM_USER + 7
RB_INSERTBANDW	    = WM_USER + 10
RB_SETBANDINFOW     = WM_USER + 11
RB_GETBANDCOUNT     = WM_USER + 12
RB_GETROWCOUNT	    = WM_USER + 13
RB_GETROWHEIGHT     = WM_USER + 14
RB_IDTOINDEX	    = WM_USER + 16
RB_GETTOOLTIPS	    = WM_USER + 17
RB_SETTOOLTIPS	    = WM_USER + 18
RB_SETBKCOLOR	    = WM_USER + 19
RB_GETBKCOLOR	    = WM_USER + 20
RB_SETTEXTCOLOR     = WM_USER + 21
RB_GETTEXTCOLOR     = WM_USER + 22
RB_SIZETORECT	    = WM_USER + 23
RB_BEGINDRAG	    = WM_USER + 24
RB_ENDDRAG	    = WM_USER + 25
RB_DRAGMOVE	    = WM_USER + 26
RB_GETBARHEIGHT     = WM_USER + 27
RB_GETBANDINFOW     = WM_USER + 28
RB_GETBANDINFOA     = WM_USER + 29
RB_MINIMIZEBAND     = WM_USER + 30
RB_MAXIMIZEBAND     = WM_USER + 31
RB_GETDROPTARGET    = CCM_GETDROPTARGET
RB_GETBANDBORDERS   = WM_USER + 34
RB_SHOWBAND	    = WM_USER + 35
RB_SETPALETTE	    = WM_USER + 37
RB_GETPALETTE	    = WM_USER + 38
RB_MOVEBAND	    = WM_USER + 39
RB_SETUNICODEFORMAT = CCM_SETUNICODEFORMAT
RB_GETUNICODEFORMAT = CCM_GETUNICODEFORMAT
RB_INSERTBAND	    = RB_INSERTBANDA
RB_SETBANDINFO	    = RB_SETBANDINFOA

; ReBar notifications

RBN_HEIGHTCHANGE  = RBN_FIRST - 0
RBN_GETOBJECT	  = RBN_FIRST - 1
RBN_LAYOUTCHANGED = RBN_FIRST - 2
RBN_AUTOSIZE	  = RBN_FIRST - 3
RBN_BEGINDRAG	  = RBN_FIRST - 4
RBN_ENDDRAG	  = RBN_FIRST - 5
RBN_DELETINGBAND  = RBN_FIRST - 6
RBN_DELETEDBAND   = RBN_FIRST - 7
RBN_CHILDSIZE	  = RBN_FIRST - 8

; Tooltip styles

TTS_ALWAYSTIP = 1
TTS_NOPREFIX  = 2

; Tooltip flags

TTF_IDISHWND   = 01h
TTF_CENTERTIP  = 02h
TTF_RTLREADING = 04h
TTF_SUBCLASS   = 10h

; Tooltip durations

TTDT_AUTOMATIC = 0
TTDT_RESHOW    = 1
TTDT_AUTOPOP   = 2
TTDT_INITIAL   = 3

; Tooltip messages

TTM_ACTIVATE	    = WM_USER + 1
TTM_SETDELAYTIME    = WM_USER + 3
TTM_ADDTOOLA	    = WM_USER + 4
TTM_DELTOOLA	    = WM_USER + 5
TTM_NEWTOOLRECTA    = WM_USER + 6
TTM_RELAYEVENT	    = WM_USER + 7
TTM_GETTOOLINFOA    = WM_USER + 8
TTM_SETTOOLINFOA    = WM_USER + 9
TTM_HITTESTA	    = WM_USER + 10
TTM_GETTEXTA	    = WM_USER + 11
TTM_UPDATETIPTEXTA  = WM_USER + 12
TTM_GETTOOLCOUNT    = WM_USER + 13
TTM_ENUMTOOLSA	    = WM_USER + 14
TTM_GETCURRENTTOOLA = WM_USER + 15
TTM_WINDOWFROMPOINT = WM_USER + 16
TTM_ADDTOOLW	    = WM_USER + 50
TTM_DELTOOLW	    = WM_USER + 51
TTM_NEWTOOLRECTW    = WM_USER + 52
TTM_GETTOOLINFOW    = WM_USER + 53
TTM_SETTOOLINFOW    = WM_USER + 54
TTM_HITTESTW	    = WM_USER + 55
TTM_GETTEXTW	    = WM_USER + 56
TTM_UPDATETIPTEXTW  = WM_USER + 57
TTM_ENUMTOOLSW	    = WM_USER + 58
TTM_GETCURRENTTOOLW = WM_USER + 59
TTM_ADDTOOL	    = TTM_ADDTOOLA
TTM_DELTOOL	    = TTM_DELTOOLA
TTM_NEWTOOLRECT     = TTM_NEWTOOLRECTA
TTM_GETTOOLINFO     = TTM_GETTOOLINFOA
TTM_SETTOOLINFO     = TTM_SETTOOLINFOA
TTM_HITTEST	    = TTM_HITTESTA
TTM_GETTEXT	    = TTM_GETTEXTA
TTM_UPDATETIPTEXT   = TTM_UPDATETIPTEXTA
TTM_ENUMTOOLS	    = TTM_ENUMTOOLSA
TTM_GETCURRENTTOOL  = TTM_GETCURRENTTOOLA

; Tooltip notifications

TTN_NEEDTEXTA = TTN_FIRST - 0
TTN_SHOW      = TTN_FIRST - 1
TTN_POP       = TTN_FIRST - 2
TTN_NEEDTEXTW = TTN_FIRST - 10
TTN_NEEDTEXT  = TTN_NEEDTEXTA

; Status bar styles

SBARS_SIZEGRIP = 100h

; Status bar messages

SB_SETTEXTA	  = WM_USER + 1
SB_GETTEXTA	  = WM_USER + 2
SB_GETTEXTLENGTHA = WM_USER + 3
SB_SETPARTS	  = WM_USER + 4
SB_GETPARTS	  = WM_USER + 6
SB_GETBORDERS	  = WM_USER + 7
SB_SETMINHEIGHT   = WM_USER + 8
SB_SIMPLE	  = WM_USER + 9
SB_GETRECT	  = WM_USER + 10
SB_SETTEXTW	  = WM_USER + 11
SB_GETTEXTW	  = WM_USER + 13
SB_GETTEXTLENGTHW = WM_USER + 12
SB_SETTEXT	  = SB_SETTEXTA
SB_GETTEXT	  = SB_GETTEXTA
SB_GETTEXTLENGTH  = SB_GETTEXTLENGTHA

; Status bar drawing types

SBT_OWNERDRAW  = 1000h
SBT_NOBORDERS  = 0100h
SBT_POPOUT     = 0200h
SBT_RTLREADING = 0400h

; Trackbar styles

TBS_AUTOTICKS	   = 01h
TBS_VERT	   = 02h
TBS_HORZ	   = 00h
TBS_TOP 	   = 04h
TBS_BOTTOM	   = 00h
TBS_LEFT	   = 04h
TBS_RIGHT	   = 00h
TBS_BOTH	   = 08h
TBS_NOTICKS	   = 10h
TBS_ENABLESELRANGE = 20h
TBS_FIXEDLENGTH    = 40h
TBS_NOTHUMB	   = 80h

; Trackbar messages

TBM_GETPOS	   = WM_USER + 0
TBM_GETRANGEMIN    = WM_USER + 1
TBM_GETRANGEMAX    = WM_USER + 2
TBM_GETTIC	   = WM_USER + 3
TBM_SETTIC	   = WM_USER + 4
TBM_SETPOS	   = WM_USER + 5
TBM_SETRANGE	   = WM_USER + 6
TBM_SETRANGEMIN    = WM_USER + 7
TBM_SETRANGEMAX    = WM_USER + 8
TBM_CLEARTICS	   = WM_USER + 9
TBM_SETSEL	   = WM_USER + 10
TBM_SETSELSTART    = WM_USER + 11
TBM_SETSELEND	   = WM_USER + 12
TBM_GETPTICS	   = WM_USER + 14
TBM_GETTICPOS	   = WM_USER + 15
TBM_GETNUMTICS	   = WM_USER + 16
TBM_GETSELSTART    = WM_USER + 17
TBM_GETSELEND	   = WM_USER + 18
TBM_CLEARSEL	   = WM_USER + 19
TBM_SETTICFREQ	   = WM_USER + 20
TBM_SETPAGESIZE    = WM_USER + 21
TBM_GETPAGESIZE    = WM_USER + 22
TBM_SETLINESIZE    = WM_USER + 23
TBM_GETLINESIZE    = WM_USER + 24
TBM_GETTHUMBRECT   = WM_USER + 25
TBM_GETCHANNELRECT = WM_USER + 26
TBM_SETTHUMBLENGTH = WM_USER + 27
TBM_GETTHUMBLENGTH = WM_USER + 28

; Trackbar notifications

TB_LINEUP	 = 0
TB_LINEDOWN	 = 1
TB_PAGEUP	 = 2
TB_PAGEDOWN	 = 3
TB_THUMBPOSITION = 4
TB_THUMBTRACK	 = 5
TB_TOP		 = 6
TB_BOTTOM	 = 7
TB_ENDTRACK	 = 8

; Up-down control styles

UDS_WRAP	= 01h
UDS_SETBUDDYINT = 02h
UDS_ALIGNRIGHT	= 04h
UDS_ALIGNLEFT	= 08h
UDS_AUTOBUDDY	= 10h
UDS_ARROWKEYS	= 20h
UDS_HORZ	= 40h
UDS_NOTHOUSANDS = 80h

; Up-down control messages

UDM_SETRANGE = WM_USER + 101
UDM_GETRANGE = WM_USER + 102
UDM_SETPOS   = WM_USER + 103
UDM_GETPOS   = WM_USER + 104
UDM_SETBUDDY = WM_USER + 105
UDM_GETBUDDY = WM_USER + 106
UDM_SETACCEL = WM_USER + 107
UDM_GETACCEL = WM_USER + 108
UDM_SETBASE  = WM_USER + 109
UDM_GETBASE  = WM_USER + 110

; Up-down control notifications

UDN_DELTAPOS = UDN_FIRST - 1

; Progress bar messages

PBM_SETRANGE   = WM_USER + 1
PBM_SETPOS     = WM_USER + 2
PBM_DELTAPOS   = WM_USER + 3
PBM_SETSTEP    = WM_USER + 4
PBM_STEPIT     = WM_USER + 5
PBM_SETRANGE32 = WM_USER + 6
PBM_GETRANGE   = WM_USER + 7
PBM_GETPOS     = WM_USER + 8

; Hot-key control messages

HKM_SETHOTKEY = WM_USER + 1
HKM_GETHOTKEY = WM_USER + 2
HKM_SETRULES  = WM_USER + 3

; Hot key flags

HOTKEYF_SHIFT	= 1
HOTKEYF_CONTROL = 2
HOTKEYF_ALT	= 4
HOTKEYF_EXT	= 8

; Key combination flags

HKCOMB_NONE = 01h
HKCOMB_S    = 02h
HKCOMB_C    = 04h
HKCOMB_A    = 08h
HKCOMB_SC   = 10h
HKCOMB_SA   = 20h
HKCOMB_CA   = 40h
HKCOMB_SCA  = 80h

; List view styles

LVS_ICON	    = 0000h
LVS_REPORT	    = 0001h
LVS_SMALLICON	    = 0002h
LVS_LIST	    = 0003h
LVS_TYPEMASK	    = 0003h
LVS_SINGLESEL	    = 0004h
LVS_SHOWSELALWAYS   = 0008h
LVS_SORTASCENDING   = 0010h
LVS_SORTDESCENDING  = 0020h
LVS_SHAREIMAGELISTS = 0040h
LVS_NOLABELWRAP     = 0080h
LVS_AUTOARRANGE     = 0100h
LVS_EDITLABELS	    = 0200h
LVS_OWNERDATA	    = 1000h
LVS_NOSCROLL	    = 2000h
LVS_ALIGNTOP	    = 0000h
LVS_ALIGNLEFT	    = 0800h
LVS_OWNERDRAWFIXED  = 0400h
LVS_NOCOLUMNHEADER  = 4000h
LVS_NOSORTHEADER    = 8000h

; List view extended styles

LVS_EX_GRIDLINES	= 0001h
LVS_EX_SUBITEMIMAGES	= 0002h
LVS_EX_CHECKBOXES	= 0004h
LVS_EX_TRACKSELECT	= 0008h
LVS_EX_HEADERDRAGDROP	= 0010h
LVS_EX_FULLROWSELECT	= 0020h
LVS_EX_ONECLICKACTIVATE = 0040h
LVS_EX_TWOCLICKACTIVATE = 0080h
LVS_EX_FLATSB		= 0100h
LVS_EX_REGIONAL 	= 0200h
LVS_EX_INFOTIP		= 0400h
LVS_EX_UNDERLINEHOT	= 0800h
LVS_EX_UNDERLINECOLD	= 1000h
LVS_EX_MULTIWORKAREAS	= 2000h
LVS_EX_LABELTIP 	= 4000h

; List view messages

LVM_GETBKCOLOR		     = LVM_FIRST + 0
LVM_SETBKCOLOR		     = LVM_FIRST + 1
LVM_GETIMAGELIST	     = LVM_FIRST + 2
LVM_SETIMAGELIST	     = LVM_FIRST + 3
LVM_GETITEMCOUNT	     = LVM_FIRST + 4
LVM_GETITEMA		     = LVM_FIRST + 5
LVM_SETITEMA		     = LVM_FIRST + 6
LVM_INSERTITEMA 	     = LVM_FIRST + 7
LVM_DELETEITEM		     = LVM_FIRST + 8
LVM_DELETEALLITEMS	     = LVM_FIRST + 9
LVM_GETCALLBACKMASK	     = LVM_FIRST + 10
LVM_SETCALLBACKMASK	     = LVM_FIRST + 11
LVM_GETNEXTITEM 	     = LVM_FIRST + 12
LVM_FINDITEMA		     = LVM_FIRST + 13
LVM_GETITEMRECT 	     = LVM_FIRST + 14
LVM_SETITEMPOSITION	     = LVM_FIRST + 15
LVM_GETITEMPOSITION	     = LVM_FIRST + 16
LVM_GETSTRINGWIDTHA	     = LVM_FIRST + 17
LVM_HITTEST		     = LVM_FIRST + 18
LVM_ENSUREVISIBLE	     = LVM_FIRST + 19
LVM_SCROLL		     = LVM_FIRST + 20
LVM_REDRAWITEMS 	     = LVM_FIRST + 21
LVM_ARRANGE		     = LVM_FIRST + 22
LVM_EDITLABELA		     = LVM_FIRST + 23
LVM_GETEDITCONTROL	     = LVM_FIRST + 24
LVM_GETCOLUMNA		     = LVM_FIRST + 25
LVM_SETCOLUMNA		     = LVM_FIRST + 26
LVM_INSERTCOLUMNA	     = LVM_FIRST + 27
LVM_DELETECOLUMN	     = LVM_FIRST + 28
LVM_GETCOLUMNWIDTH	     = LVM_FIRST + 29
LVM_SETCOLUMNWIDTH	     = LVM_FIRST + 30
LVM_CREATEDRAGIMAGE	     = LVM_FIRST + 33
LVM_GETVIEWRECT 	     = LVM_FIRST + 34
LVM_GETTEXTCOLOR	     = LVM_FIRST + 35
LVM_SETTEXTCOLOR	     = LVM_FIRST + 36
LVM_GETTEXTBKCOLOR	     = LVM_FIRST + 37
LVM_SETTEXTBKCOLOR	     = LVM_FIRST + 38
LVM_GETTOPINDEX 	     = LVM_FIRST + 39
LVM_GETCOUNTPERPAGE	     = LVM_FIRST + 40
LVM_GETORIGIN		     = LVM_FIRST + 41
LVM_UPDATE		     = LVM_FIRST + 42
LVM_SETITEMSTATE	     = LVM_FIRST + 43
LVM_GETITEMSTATE	     = LVM_FIRST + 44
LVM_GETITEMTEXTA	     = LVM_FIRST + 45
LVM_SETITEMTEXTA	     = LVM_FIRST + 46
LVM_SETITEMCOUNT	     = LVM_FIRST + 47
LVM_SORTITEMS		     = LVM_FIRST + 48
LVM_SETITEMPOSITION32	     = LVM_FIRST + 49
LVM_GETSELECTEDCOUNT	     = LVM_FIRST + 50
LVM_GETITEMSPACING	     = LVM_FIRST + 51
LVM_GETISEARCHSTRINGA	     = LVM_FIRST + 52
LVM_SETICONSPACING	     = LVM_FIRST + 53
LVM_SETEXTENDEDLISTVIEWSTYLE = LVM_FIRST + 54
LVM_GETEXTENDEDLISTVIEWSTYLE = LVM_FIRST + 55
LVM_GETSUBITEMRECT	     = LVM_FIRST + 56
LVM_SUBITEMHITTEST	     = LVM_FIRST + 57
LVM_SETCOLUMNORDERARRAY      = LVM_FIRST + 58
LVM_GETCOLUMNORDERARRAY      = LVM_FIRST + 59
LVM_SETHOTITEM		     = LVM_FIRST + 60
LVM_GETHOTITEM		     = LVM_FIRST + 61
LVM_SETHOTCURSOR	     = LVM_FIRST + 62
LVM_GETHOTCURSOR	     = LVM_FIRST + 63
LVM_APPROXIMATEVIEWRECT      = LVM_FIRST + 64
LVM_SETWORKAREA 	     = LVM_FIRST + 65
LVM_GETITEMW		     = LVM_FIRST + 75
LVM_SETITEMW		     = LVM_FIRST + 76
LVM_INSERTITEMW 	     = LVM_FIRST + 77
LVM_FINDITEMW		     = LVM_FIRST + 83
LVM_GETSTRINGWIDTHW	     = LVM_FIRST + 87
LVM_GETCOLUMNW		     = LVM_FIRST + 95
LVM_SETCOLUMNW		     = LVM_FIRST + 96
LVM_INSERTCOLUMNW	     = LVM_FIRST + 97
LVM_GETITEMTEXTW	     = LVM_FIRST + 115
LVM_SETITEMTEXTW	     = LVM_FIRST + 116
LVM_GETISEARCHSTRINGW	     = LVM_FIRST + 117
LVM_EDITLABELW		     = LVM_FIRST + 118
LVM_GETITEM		     = LVM_GETITEMA
LVM_SETITEM		     = LVM_SETITEMA
LVM_INSERTITEM		     = LVM_INSERTITEMA
LVM_FINDITEM		     = LVM_FINDITEMA
LVM_GETSTRINGWIDTH	     = LVM_GETSTRINGWIDTHA
LVM_GETCOLUMN		     = LVM_GETCOLUMNA
LVM_SETCOLUMN		     = LVM_SETCOLUMNA
LVM_INSERTCOLUMN	     = LVM_INSERTCOLUMNA
LVM_GETITEMTEXT 	     = LVM_GETITEMTEXTA
LVM_SETITEMTEXT 	     = LVM_SETITEMTEXTA
LVM_GETISEARCHSTRING	     = LVM_GETISEARCHSTRINGA
LVM_EDITLABEL		     = LVM_EDITLABELA

; List view image list types

LVSIL_NORMAL = 0
LVSIL_SMALL  = 1
LVSIL_STATE  = 2

; LVM_SETITEMCOUNT flags

LVSICF_NOINVALIDATEALL = 1
LVSICF_NOSCROLL        = 2

; List view item structure flags

LVIF_TEXT	 = 0001h
LVIF_IMAGE	 = 0002h
LVIF_PARAM	 = 0004h
LVIF_STATE	 = 0008h
LVIF_INDENT	 = 0010h
LVIF_NORECOMPUTE = 0800h
LVIF_DI_SETITEM  = 1000h

; List view item states

LVIS_FOCUSED	    = 00001h
LVIS_SELECTED	    = 00002h
LVIS_CUT	    = 00004h
LVIS_DROPHILITED    = 00008h
LVIS_ACTIVATING  = 0020h
LVIS_OVERLAYMASK    = 00F00h
LVIS_STATEIMAGEMASK = 0F000h

; List view callback item values

LPSTR_TEXTCALLBACK = -1
I_IMAGECALLBACK    = -1
I_CHILDRENCALLBACK = -1

; List view next item relations

LVNI_ALL	 = 000h
LVNI_FOCUSED	 = 001h
LVNI_SELECTED	 = 002h
LVNI_CUT	 = 004h
LVNI_DROPHILITED = 008h
LVNI_ABOVE	 = 100h
LVNI_BELOW	 = 200h
LVNI_TOLEFT	 = 400h
LVNI_TORIGHT	 = 800h

; List view search types

LVFI_PARAM     = 01h
LVFI_STRING    = 02h
LVFI_PARTIAL   = 08h
LVFI_WRAP      = 20h
LVFI_NEARESTXY = 40h

; List view item rectangle types

LVIR_BOUNDS	  = 0
LVIR_ICON	  = 1
LVIR_LABEL	  = 2
LVIR_SELECTBOUNDS = 3

; List view hit test flags

LVHT_NOWHERE	    = 01h
LVHT_ONITEMICON     = 02h
LVHT_ONITEMLABEL    = 04h
LVHT_ONITEMSTATEICON= 08h
LVHT_ONITEM	    = LVHT_ONITEMICON or LVHT_ONITEMLABEL or LVHT_ONITEMSTATEICON
LVHT_ABOVE	    = 08h
LVHT_BELOW	    = 10h
LVHT_TORIGHT	    = 20h
LVHT_TOLEFT	    = 40h

; List view alignment values

LVA_DEFAULT	   = 000h
LVA_ALIGNLEFT	   = 001h
LVA_ALIGNTOP	   = 002h
LVA_ALIGNRIGHT	   = 003h
LVA_ALIGNBOTTOM    = 004h
LVA_SNAPTOGRID	   = 005h
LVA_SORTASCENDING  = 100h
LVA_SORTDESCENDING = 200h

; List view column structure flags

LVCF_FMT     = 1
LVCF_WIDTH   = 2
LVCF_TEXT    = 4
LVCF_SUBITEM = 8

; List view column alignment values

LVCFMT_LEFT	   = 0
LVCFMT_RIGHT	   = 1
LVCFMT_CENTER	   = 2
LVCFMT_JUSTIFYMASK = 3

; List view column width values

LVSCW_AUTOSIZE		 = -1
LVSCW_AUTOSIZE_USEHEADER = -2

; List view notifications

LVN_ITEMCHANGING    = LVN_FIRST - 0
LVN_ITEMCHANGED     = LVN_FIRST - 1
LVN_INSERTITEM	    = LVN_FIRST - 2
LVN_DELETEITEM	    = LVN_FIRST - 3
LVN_DELETEALLITEMS  = LVN_FIRST - 4
LVN_BEGINLABELEDITA = LVN_FIRST - 5
LVN_ENDLABELEDITA   = LVN_FIRST - 6
LVN_COLUMNCLICK     = LVN_FIRST - 8
LVN_BEGINDRAG	    = LVN_FIRST - 9
LVN_BEGINRDRAG	    = LVN_FIRST - 11
LVN_ODCACHEHINT     = LVN_FIRST - 13
LVN_GETDISPINFOA    = LVN_FIRST - 50
LVN_SETDISPINFOA    = LVN_FIRST - 51
LVN_ODFINDITEMA     = LVN_FIRST - 52
LVN_KEYDOWN	    = LVN_FIRST - 55
LVN_BEGINLABELEDITW = LVN_FIRST - 75
LVN_ENDLABELEDITW   = LVN_FIRST - 76
LVN_GETDISPINFOW    = LVN_FIRST - 77
LVN_SETDISPINFOW    = LVN_FIRST - 78
LVN_ODFINDITEMW     = LVN_FIRST - 79
LVN_BEGINLABELEDIT  = LVN_BEGINLABELEDITA
LVN_ENDLABELEDIT    = LVN_ENDLABELEDITA
LVN_GETDISPINFO     = LVN_GETDISPINFOA
LVN_SETDISPINFO     = LVN_SETDISPINFOA
LVN_ODFINDITEM	    = LVN_ODFINDITEMA

; Tree view styles

TVS_HASBUTTONS	    = 0001h
TVS_HASLINES	    = 0002h
TVS_LINESATROOT     = 0004h
TVS_EDITLABELS	    = 0008h
TVS_DISABLEDRAGDROP = 0010h
TVS_SHOWSELALWAYS   = 0020h
TVS_RTLREADING	    = 0040h
TVS_NOTOOLTIPS	    = 0080h
TVS_CHECKBOXES	    = 0100h
TVS_TRACKSELECT     = 0200h
TVS_SINGLEEXPAND    = 0400h
TVS_INFOTIP	    = 0800h
TVS_FULLROWSELECT   = 1000h
TVS_NOSCROLL	    = 2000h
TVS_NONEVENHEIGHT   = 4000h

; Tree view item structure flags

TVIF_TEXT	   = 0001h
TVIF_IMAGE	   = 0002h
TVIF_PARAM	   = 0004h
TVIF_STATE	   = 0008h
TVIF_HANDLE	   = 0010h
TVIF_SELECTEDIMAGE = 0020h
TVIF_CHILDREN	   = 0040h
TVIF_DI_SETITEM    = 1000h

; Tree view item states

TVIS_FOCUSED	    = 00001h
TVIS_SELECTED	    = 00002h
TVIS_CUT	    = 00004h
TVIS_DROPHILITED    = 00008h
TVIS_BOLD	    = 00010h
TVIS_EXPANDED	    = 00020h
TVIS_EXPANDEDONCE   = 00040h
TVIS_EXPANDPARTIAL  = 00080h
TVIS_OVERLAYMASK    = 00F00h
TVIS_STATEIMAGEMASK = 0F000h
TVIS_USERMASK	    = 0F000h

; Tree view predefined item values

TVI_ROOT  = 0FFFF0000h
TVI_FIRST = 0FFFF0001h
TVI_LAST  = 0FFFF0002h
TVI_SORT  = 0FFFF0003h

; Tree view messages

TVM_INSERTITEMA       = TV_FIRST + 0
TVM_DELETEITEM	      = TV_FIRST + 1
TVM_EXPAND	      = TV_FIRST + 2
TVM_GETITEMRECT       = TV_FIRST + 4
TVM_GETCOUNT	      = TV_FIRST + 5
TVM_GETINDENT	      = TV_FIRST + 6
TVM_SETINDENT	      = TV_FIRST + 7
TVM_GETIMAGELIST      = TV_FIRST + 8
TVM_SETIMAGELIST      = TV_FIRST + 9
TVM_GETNEXTITEM       = TV_FIRST + 10
TVM_SELECTITEM	      = TV_FIRST + 11
TVM_GETITEMA	      = TV_FIRST + 12
TVM_SETITEMA	      = TV_FIRST + 13
TVM_EDITLABELA	      = TV_FIRST + 14
TVM_GETEDITCONTROL    = TV_FIRST + 15
TVM_GETVISIBLECOUNT   = TV_FIRST + 16
TVM_HITTEST	      = TV_FIRST + 17
TVM_CREATEDRAGIMAGE   = TV_FIRST + 18
TVM_SORTCHILDREN      = TV_FIRST + 19
TVM_ENSUREVISIBLE     = TV_FIRST + 20
TVM_SORTCHILDRENCB    = TV_FIRST + 21
TVM_ENDEDITLABELNOW   = TV_FIRST + 22
TVM_GETISEARCHSTRINGA = TV_FIRST + 23
TVM_INSERTITEMW       = TV_FIRST + 50
TVM_GETITEMW	      = TV_FIRST + 62
TVM_SETITEMW	      = TV_FIRST + 63
TVM_GETISEARCHSTRINGW = TV_FIRST + 64
TVM_EDITLABELW	      = TV_FIRST + 65
TVM_INSERTITEM	      = TVM_INSERTITEMA
TVM_GETITEM	      = TVM_GETITEMA
TVM_SETITEM	      = TVM_SETITEMA
TVM_GETISEARCHSTRING  = TVM_GETISEARCHSTRINGA
TVM_EDITLABEL	      = TVM_EDITLABELA

; Tree view action flags

TVE_COLLAPSE	  = 0001h
TVE_EXPAND	  = 0002h
TVE_TOGGLE	  = 0003h
TVE_EXPANDPARTIAL = 4000h
TVE_COLLAPSERESET = 8000h

; Tree view image list types

TVSIL_NORMAL = 0
TVSIL_STATE  = 2

; Tree view next item types

TVGN_ROOT	     = 0
TVGN_NEXT	     = 1
TVGN_PREVIOUS	     = 2
TVGN_PARENT	     = 3
TVGN_CHILD	     = 4
TVGN_FIRSTVISIBLE    = 5
TVGN_NEXTVISIBLE     = 6
TVGN_PREVIOUSVISIBLE = 7
TVGN_DROPHILITE      = 8
TVGN_CARET	     = 9

; Tree view hit test flags

TVHT_NOWHERE	     = 001h
TVHT_ONITEMICON      = 002h
TVHT_ONITEMLABEL     = 004h
TVHT_ONITEMINDENT    = 008h
TVHT_ONITEMBUTTON    = 010h
TVHT_ONITEMRIGHT     = 020h
TVHT_ONITEMSTATEICON = 040h
TVHT_ONITEM	     = TVHT_ONITEMICON or TVHT_ONITEMLABEL or TVHT_ONITEMSTATEICON
TVHT_ABOVE	     = 100h
TVHT_BELOW	     = 200h
TVHT_TORIGHT	     = 400h
TVHT_TOLEFT	     = 800h

; Tree view notifications

TVN_SELCHANGINGA    = TVN_FIRST - 1
TVN_SELCHANGEDA     = TVN_FIRST - 2
TVN_GETDISPINFOA    = TVN_FIRST - 3
TVN_SETDISPINFOA    = TVN_FIRST - 4
TVN_ITEMEXPANDINGA  = TVN_FIRST - 5
TVN_ITEMEXPANDEDA   = TVN_FIRST - 6
TVN_BEGINDRAGA	    = TVN_FIRST - 7
TVN_BEGINRDRAGA     = TVN_FIRST - 8
TVN_DELETEITEMA     = TVN_FIRST - 9
TVN_BEGINLABELEDITA = TVN_FIRST - 10
TVN_ENDLABELEDITA   = TVN_FIRST - 11
TVN_KEYDOWN	    = TVN_FIRST - 12
TVN_SELCHANGINGW    = TVN_FIRST - 50
TVN_SELCHANGEDW     = TVN_FIRST - 51
TVN_GETDISPINFOW    = TVN_FIRST - 52
TVN_SETDISPINFOW    = TVN_FIRST - 53
TVN_ITEMEXPANDINGW  = TVN_FIRST - 54
TVN_ITEMEXPANDEDW   = TVN_FIRST - 55
TVN_BEGINDRAGW	    = TVN_FIRST - 56
TVN_BEGINRDRAGW     = TVN_FIRST - 57
TVN_DELETEITEMW     = TVN_FIRST - 58
TVN_BEGINLABELEDITW = TVN_FIRST - 59
TVN_ENDLABELEDITW   = TVN_FIRST - 60
TVN_SELCHANGING     = TVN_SELCHANGINGA
TVN_SELCHANGED	    = TVN_SELCHANGEDA
TVN_GETDISPINFO     = TVN_GETDISPINFOA
TVN_SETDISPINFO     = TVN_SETDISPINFOA
TVN_ITEMEXPANDING   = TVN_ITEMEXPANDINGA
TVN_ITEMEXPANDED    = TVN_ITEMEXPANDEDA
TVN_BEGINDRAG	    = TVN_BEGINDRAGA
TVN_BEGINRDRAG	    = TVN_BEGINRDRAGA
TVN_DELETEITEM	    = TVN_DELETEITEMA
TVN_BEGINLABELEDIT  = TVN_BEGINLABELEDITA
TVN_ENDLABELEDIT    = TVN_ENDLABELEDITA

; Tree view action flags

TVC_UNKNOWN    = 0
TVC_BYMOUSE    = 1
TVC_BYKEYBOARD = 2

; Tab control styles

TCS_SCROLLOPPOSITE    = 0001h
TCS_BOTTOM	      = 0002h
TCS_RIGHT	      = 0002h
TCS_FORCEICONLEFT     = 0010h
TCS_FORCELABELLEFT    = 0020h
TCS_HOTTRACK	      = 0040h
TCS_VERTICAL	      = 0080h
TCS_TABS	      = 0000h
TCS_BUTTONS	      = 0100h
TCS_SINGLELINE	      = 0000h
TCS_MULTILINE	      = 0200h
TCS_RIGHTJUSTIFY      = 0000h
TCS_FIXEDWIDTH	      = 0400h
TCS_RAGGEDRIGHT       = 0800h
TCS_FOCUSONBUTTONDOWN = 1000h
TCS_OWNERDRAWFIXED    = 2000h
TCS_TOOLTIPS	      = 4000h
TCS_FOCUSNEVER	      = 8000h

; Tab control messages

TCM_GETIMAGELIST   = TCM_FIRST + 2
TCM_SETIMAGELIST   = TCM_FIRST + 3
TCM_GETITEMCOUNT   = TCM_FIRST + 4
TCM_GETITEMA	   = TCM_FIRST + 5
TCM_SETITEMA	   = TCM_FIRST + 6
TCM_INSERTITEMA    = TCM_FIRST + 7
TCM_DELETEITEM	   = TCM_FIRST + 8
TCM_DELETEALLITEMS = TCM_FIRST + 9
TCM_GETITEMRECT    = TCM_FIRST + 10
TCM_GETCURSEL	   = TCM_FIRST + 11
TCM_SETCURSEL	   = TCM_FIRST + 12
TCM_HITTEST	   = TCM_FIRST + 13
TCM_SETITEMEXTRA   = TCM_FIRST + 14
TCM_ADJUSTRECT	   = TCM_FIRST + 40
TCM_SETITEMSIZE    = TCM_FIRST + 41
TCM_REMOVEIMAGE    = TCM_FIRST + 42
TCM_SETPADDING	   = TCM_FIRST + 43
TCM_GETROWCOUNT    = TCM_FIRST + 44
TCM_GETTOOLTIPS    = TCM_FIRST + 45
TCM_SETTOOLTIPS    = TCM_FIRST + 46
TCM_GETCURFOCUS    = TCM_FIRST + 47
TCM_SETCURFOCUS    = TCM_FIRST + 48
TCM_GETITEMW	   = TCM_FIRST + 60
TCM_SETITEMW	   = TCM_FIRST + 61
TCM_INSERTITEMW    = TCM_FIRST + 62
TCM_GETITEM	   = TCM_GETITEMA
TCM_SETITEM	   = TCM_SETITEMA
TCM_INSERTITEM	   = TCM_INSERTITEMA

; Tab control item structure flags

TCIF_TEXT	= 1
TCIF_IMAGE	= 2
TCIF_RTLREADING = 4
TCIF_PARAM	= 8

; Tab control hit test flags

TCHT_NOWHERE	 = 1
TCHT_ONITEMICON  = 2
TCHT_ONITEMLABEL = 4
TCHT_ONITEM	 = TCHT_ONITEMICON or TCHT_ONITEMLABEL

; Tab control notifications

TCN_KEYDOWN	= TCN_FIRST - 0
TCN_SELCHANGE	= TCN_FIRST - 1
TCN_SELCHANGING = TCN_FIRST - 2

; Animation control styles

ACS_CENTER	= 1
ACS_TRANSPARENT = 2
ACS_AUTOPLAY	= 4
ACS_TIMER	= 8

; Animation control messages

ACM_OPENA = WM_USER + 100
ACM_PLAY  = WM_USER + 101
ACM_STOP  = WM_USER + 102
ACM_OPENW = WM_USER + 103
ACM_OPEN  = ACM_OPENA

; Animation control notifications

ACN_START = 1
ACN_STOP  = 2

; Month calendar styles

MCS_DAYSTATE	= 1
MCS_MULTISELECT = 2
MCS_WEEKNUMBERS = 4
MCS_NOTODAY	= 8

; Month calendar messages

MCM_GETCURSEL	      = MCM_FIRST + 1
MCM_SETCURSEL	      = MCM_FIRST + 2
MCM_GETMAXSELCOUNT    = MCM_FIRST + 3
MCM_SETMAXSELCOUNT    = MCM_FIRST + 4
MCM_GETSELRANGE       = MCM_FIRST + 5
MCM_SETSELRANGE       = MCM_FIRST + 6
MCM_GETMONTHRANGE     = MCM_FIRST + 7
MCM_SETDAYSTATE       = MCM_FIRST + 8
MCM_GETMINREQRECT     = MCM_FIRST + 9
MCM_SETCOLOR	      = MCM_FIRST + 10
MCM_GETCOLOR	      = MCM_FIRST + 11
MCM_SETTODAY	      = MCM_FIRST + 12
MCM_GETTODAY	      = MCM_FIRST + 13
MCM_HITTEST	      = MCM_FIRST + 14
MCM_SETFIRSTDAYOFWEEK = MCM_FIRST + 15
MCM_GETFIRSTDAYOFWEEK = MCM_FIRST + 16
MCM_GETRANGE	      = MCM_FIRST + 17
MCM_SETRANGE	      = MCM_FIRST + 18
MCM_GETMONTHDELTA     = MCM_FIRST + 19
MCM_SETMONTHDELTA     = MCM_FIRST + 20

; Month calendar hit test flags

MCHT_TITLE	      = 0010000h
MCHT_CALENDAR	      = 0020000h
MCHT_TODAYLINK	      = 0030000h
MCHT_NEXT	      = 1000000h
MCHT_PREV	      = 2000000h
MCHT_NOWHERE	      = 0000000h
MCHT_TITLEBK	      = MCHT_TITLE
MCHT_TITLEMONTH       = MCHT_TITLE or 1
MCHT_TITLEYEAR	      = MCHT_TITLE or 2
MCHT_TITLEBTNNEXT     = MCHT_TITLE or MCHT_NEXT or 3
MCHT_TITLEBTNPREV     = MCHT_TITLE or MCHT_PREV or 3
MCHT_CALENDARBK       = MCHT_CALENDAR
MCHT_CALENDARDATE     = MCHT_CALENDAR or 1
MCHT_CALENDARDATENEXT = MCHT_CALENDARDATE or MCHT_NEXT
MCHT_CALENDARDATEPREV = MCHT_CALENDARDATE or MCHT_PREV
MCHT_CALENDARDAY      = MCHT_CALENDAR or 2
MCHT_CALENDARWEEKNUM  = MCHT_CALENDAR or 3

; Month calendar color codes

MCSC_BACKGROUND   = 0
MCSC_TEXT	  = 1
MCSC_TITLEBK	  = 2
MCSC_TITLETEXT	  = 3
MCSC_MONTHBK	  = 4
MCSC_TRAILINGTEXT = 5

; Month calendar notifications

MCN_SELCHANGE	= MCN_FIRST + 1
MCN_GETDAYSTATE = MCN_FIRST + 3
MCN_SELECT	= MCN_FIRST + 4

; Date-time pick control messages

DTM_GETSYSTEMTIME = DTM_FIRST + 1
DTM_SETSYSTEMTIME = DTM_FIRST + 2
DTM_GETRANGE	  = DTM_FIRST + 3
DTM_SETRANGE	  = DTM_FIRST + 4
DTM_SETFORMATA	  = DTM_FIRST + 5
DTM_SETMCCOLOR	  = DTM_FIRST + 6
DTM_GETMCCOLOR	  = DTM_FIRST + 7
DTM_GETMONTHCAL   = DTM_FIRST + 8
DTM_SETMCFONT	  = DTM_FIRST + 9
DTM_GETMCFONT	  = DTM_FIRST + 10
DTM_SETFORMATW	  = DTM_FIRST + 50
DTM_SETFORMAT	  = DTM_SETFORMATA

; Date-time pick control styles

DTS_UPDOWN	    = 01h
DTS_SHOWNONE	    = 02h
DTS_SHORTDATEFORMAT = 00h
DTS_LONGDATEFORMAT  = 04h
DTS_TIMEFORMAT	    = 09h
DTS_APPCANPARSE     = 10h
DTS_RIGHTALIGN	    = 20h

; Date-time pick control notifications

DTN_DATETIMECHANGE = DTN_FIRST + 1
DTN_USERSTRINGA    = DTN_FIRST + 2
DTN_WMKEYDOWNA	   = DTN_FIRST + 3
DTN_FORMATA	   = DTN_FIRST + 4
DTN_FORMATQUERYA   = DTN_FIRST + 5
DTN_DROPDOWN	   = DTN_FIRST + 6
DTN_CLOSEUP	   = DTN_FIRST + 7
DTN_USERSTRINGW    = DTN_FIRST + 15
DTN_WMKEYDOWNW	   = DTN_FIRST + 16
DTN_FORMATW	   = DTN_FIRST + 17
DTN_FORMATQUERYW   = DTN_FIRST + 18
DTN_USERSTRING	   = DTN_USERSTRINGA
DTN_WMKEYDOWN	   = DTN_WMKEYDOWNA
DTN_FORMAT	   = DTN_FORMATA
DTN_FORMATQUERY    = DTN_FORMATQUERYA

; ImageList_LoadImage types

IMAGE_BITMAP	  = 0
IMAGE_ICON	  = 1
IMAGE_CURSOR	  = 2
IMAGE_ENHMETAFILE = 3

; ImageList_LoadImage flags

LR_DEFAULTCOLOR     = 0000h
LR_MONOCHROME	    = 0001h
LR_COLOR	    = 0002h
LR_COPYRETURNORG    = 0004h
LR_COPYDELETEORG    = 0008h
LR_LOADFROMFILE     = 0010h
LR_LOADTRANSPARENT  = 0020h
LR_DEFAULTSIZE	    = 0040h
LR_VGACOLOR	    = 0080h
LR_LOADMAP3DCOLORS  = 1000h
LR_CREATEDIBSECTION = 2000h
LR_COPYFROMRESOURCE = 4000h
LR_SHARED	    = 8000h

; IP control messages

IPM_CLEARADDRESS = WM_USER + 100
IPM_SETADDRESS	 = WM_USER + 101
IPM_GETADDRESS	 = WM_USER + 102
IPM_SETRANGE	 = WM_USER + 103
IPM_SETFOCUS	 = WM_USER + 104
IPM_ISBLANK	 = WM_USER + 105

; Custom Draw flags

CDRF_DODEFAULT	       = 0
CDRF_NEWFONT	       = 2
CDRF_SKIPDEFAULT       = 4
CDRF_NOTIFYPOSTPAINT   = 10h
CDRF_NOTIFYITEMDRAW    = 20h
CDRF_NOTIFYSUBITEMDRAW = 20h
CDRF_NOTIFYPOSTERASE   = 40h
CDDS_PREPAINT	       = 1
CDDS_POSTPAINT	       = 2
CDDS_PREERASE	       = 3
CDDS_POSTERASE	       = 4
CDDS_ITEM	       = 10000h
CDDS_ITEMPREPAINT      = CDDS_ITEM or CDDS_PREPAINT
CDDS_ITEMPOSTPAINT     = CDDS_ITEM or CDDS_POSTPAINT
CDDS_ITEMPREERASE      = CDDS_ITEM or CDDS_PREERASE
CDDS_ITEMPOSTERASE     = CDDS_ITEM or CDDS_POSTERASE
CDDS_SUBITEM	       = 20000h
CDIS_SELECTED	       = 1
CDIS_GRAYED	       = 2
CDIS_DISABLED	       = 4
CDIS_CHECKED	       = 8
CDIS_FOCUS	       = 10h
CDIS_DEFAULT	       = 20h
CDIS_HOT	       = 40h
CDIS_MARKED	       = 80h
CDIS_INDETERMINATE     = 100h
