;[]-----------------------------------------------------------------[]
;|      H_PADA.ASM -- long pointer routines                          |
;[]-----------------------------------------------------------------[]

;
;       C/C++ Run Time Library - Version 5.0
; 
;       Copyright (c) 1987, 1992 by Borland International
;       All Rights Reserved.
; 

                INCLUDE RULES.ASI

; calls to these routines are generated by the compiler to perform
; arithmetic operations on long pointers.

_TEXT           SEGMENT BYTE PUBLIC 'CODE'
                ASSUME  CS:_TEXT

                public  PADA@
                public  F_PADA@
                public  N_PADA@

N_PADA@:
                pop     es                      ;fix up far return
                push    cs
                push    es
PADA@:
F_PADA@:
                mov     es,dx
                xchg    ax,bx
;
;               Pointer to memory cell to increment is in es:bx
;               Increment amount is ax:cx
;
                mov     dx, es:2[bx]    ; DX <- Selector
                push    bx
                mov     bx, es:[bx]     ; BX <- Offset
                or      cx,cx           ; Is increment negative?
                jge     ada1            ; No, ...
                not     ax              ; Yes, ...
                not     cx
                add     ax,1
                adc     cx,0
                jmp     sba1
ada1:
                add     bx,ax           ; Add offsets
                jnc     adaok
                add     dx,1000h
adaok:
                mov     ah,cl
                mov     cl,4
                shl     ah,cl
                xor     al,al
                add     dx,ax
                mov     ch,bl
                shr     bx,cl
                add     dx,bx
                mov     al,ch
                and     ax,0fh
                pop     bx
                mov     es:[bx], ax
                mov     es:2[bx], dx
                retf

                public  PSBA@
                public  F_PSBA@
                public  N_PSBA@

N_PSBA@:
                pop     es                      ;fix up far return
                push    cs
                push    es
PSBA@:
F_PSBA@:
                mov     es,dx
                xchg    ax,bx
;
;               Pointer to memory cell to increment is in es:bx
;               Increment amount is ax:cx
;
                mov     dx,es:2[bx]
                push    bx
                mov     bx,es:[bx]
                or      cx,cx
                jge     sba1
                not     ax
                not     cx
                add     ax,1
                adc     cx,0
                jmp     ada1
sba1:
                sub     bx,ax
                jnc     sbaok
                sub     dx,1000h
sbaok:
                mov     ah,cl
                mov     cl,4
                shl     ah,cl
                xor     al,al
                sub     dx,ax
                mov     ch,bl
                shr     bx,cl
                add     dx,bx
                mov     al,ch
                and     ax,0fh
                pop     bx
                mov     es:[bx],ax
                mov     es:2[bx],dx
                retf
_TEXT           ENDS
                END
